package gov.va.med.mhv.vitals.validator;

import java.math.BigDecimal;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.dto.BodyTemperatureDTO;
import gov.va.med.mhv.vitals.util.MessagesUtil;

@Component
public class BodyTemperatureValidator extends Validator{
	
	public static final int COMMENTS_MAX_LENGTH = 255;
	private static final BigDecimal BODYTEMPERATURE_MIN_VALUE = new BigDecimal("10");
	private static final BigDecimal BODYTEMPERATURE_MAX_VALUE = new BigDecimal("999.9");
	private static final int BODYTEMPERATURE_SCALE = 1;

	
	@Autowired
	private MessagesUtil messages;
	
	public void temperatureReadingValidations(ResponseUtil response, BodyTemperatureDTO tempdto) {
		fieldValidation(response, tempdto);
	}

	private void fieldValidation(ResponseUtil response,	BodyTemperatureDTO tempdto) {
		validateComments(response,tempdto);
		validateMethod(response,tempdto);
		validateBodyTemperature(response,tempdto);
		validateReadingDate(response,tempdto);
		validateMeasure(response,tempdto);
		validateUserProfile(response,tempdto);
	}
	
	private void validateUserProfile(ResponseUtil response,BodyTemperatureDTO tempdto) {
		if( tempdto.getUserprofileId() == null ) {
			response.getValidationErrors().put("userProfile", "userProfile is required");
			return;
		}
		boolean valid= isUserProfileValid(tempdto.getUserprofileId());
		if ( !valid) {
			response.getValidationErrors().put("userProfile", "userProfile is Invalid");
		}
	}

	private void validateMeasure(ResponseUtil response, BodyTemperatureDTO tempdto) {
		String value = tempdto.getMeasure();
		if ( value == null ) {
			return;
		}		
		//TODO : fix this
		//String enumName = value.getName();
		//Validations.validateEnumeration(value, TemperatureMeasureEnumeration.getEnum(enumName), "measure", "Measure", getMessages());
		
	}

	private void validateReadingDate(ResponseUtil response,	BodyTemperatureDTO tempdto) {
		Date value = tempdto.getReading();
		if( value == null ) {
			Validations.validateRequired("readingDate", value, response.getValidationErrors());
			return;
		}
	}

	private void validateBodyTemperature(ResponseUtil response,	BodyTemperatureDTO tempdto) {
		BigDecimal value = tempdto.getBodyTemperature();
		if( value == null ) {
			Validations.validateRequired("BodyTemperature", value, response.getValidationErrors());
			return;
		}		
		Validations.validateMinValue("BodyTemperature minumum", value, BODYTEMPERATURE_MIN_VALUE,"The Body Temperature ", response.getValidationErrors());
		Validations.validateMaxValue("BodyTemperature maximum",value, BODYTEMPERATURE_MAX_VALUE,"The Body Temperature ", response.getValidationErrors());
		Validations.validateScale("BodyTemperature scale",value, BODYTEMPERATURE_SCALE, "The Body Temperature ", response.getValidationErrors());
		
	}

	private void validateMethod(ResponseUtil response,BodyTemperatureDTO tempdto) {
		
		//TODO: fix this
		/*MethodEnumeration value = getMethod();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
		
		//validate a valid enumeration value:
		String enumName = value.getName();
		Validations.validateEnumeration(value, MethodEnumeration.getEnum(enumName), "method", "Method", getMessages()); */
		
	}

	private void validateComments(ResponseUtil response, BodyTemperatureDTO tempdto) {
		String value = tempdto.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("comments",value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
		
	}

}
